<?php

namespace Tests\Controller;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\HttpFoundation\Request;

class VersionControllerTest extends WebTestCase
{

    /**
     * Ensure the response has the required data
     */
    public function testIndex()
    {
        $client = static::createClient();
        $client->request(Request::METHOD_GET, '/version');
        $version = json_decode($client->getResponse()->getContent(), true);
        $this->assertArrayHasKey('environment', $version);
        $this->assertArrayHasKey('branch', $version);
        $this->assertArrayHasKey('revision', $version);
        $this->assertArrayHasKey('build', $version);
        $this->assertArrayHasKey('date', $version);
        $this->assertInstanceOf(\DateTime::class, \DateTime::createFromFormat(DATE_W3C, $version['date']));
    }
}
