<?php

namespace Tests\Controller;

use PHPUnit\Framework\TestCase;
use WM\VersionBundle\Controller\VersionController;

class VersionControllerTest extends TestCase
{
    /**
     * Ensure the response has the required data
     */
    public function testIndex()
    {
        $obj = new VersionController(dirname(__DIR__) . '/fixtures/version.json', 'test-env');
        $ret = $obj->index();

        $version = json_decode($ret->getContent(), true);
        $this->assertArrayHasKey('environment', $version);
        $this->assertArrayHasKey('branch', $version);
        $this->assertArrayHasKey('revision', $version);
        $this->assertArrayHasKey('build', $version);
        $this->assertArrayHasKey('date', $version);
        $this->assertInstanceOf(\DateTime::class, \DateTime::createFromFormat(DATE_W3C, $version['date']));
    }
}
