<?php

namespace WM\VersionBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
final class Configuration implements ConfigurationInterface
{
    const DEFAULT_VERSION_FILE = '%kernel.project_dir%/version.json';

    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder(self::getRootName());
        $rootNode = $treeBuilder->getRootNode();

        $rootNode
            ->children()
                ->scalarNode('file')
                    ->info('Path to the version file')
                    ->defaultValue(self::DEFAULT_VERSION_FILE)
                ->end()
            ->end();

        return $treeBuilder;
    }

    public static function getRootName(): string
    {
        return 'wm_version';
    }
}
