<?php

namespace WM\VersionBundle\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\Yaml\Yaml;

/**
 * Class VersionController
 */
class VersionController
{
    private $versionFile;
    private $env;

    /**
     * @param $versionFile
     * @param $env
     */
    public function __construct(string $versionFile, string $env)
    {
        $this->versionFile = $versionFile;
        $this->env = $env;
    }

    /**
     * @return JsonResponse
     */
    public function index(): JsonResponse
    {
        if (file_exists($this->versionFile)) {
            $version = Yaml::parse(file_get_contents($this->versionFile));
        } else {
            throw new NotFoundHttpException('Unknown version');
        }
        $version = array_merge(['environment' => $this->env], $version);

        return (new JsonResponse($version, Response::HTTP_OK, []))
            ->setEncodingOptions(JsonResponse::DEFAULT_ENCODING_OPTIONS | JSON_PRETTY_PRINT);
    }
}
