<?php

namespace Allocine\VersionBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Filesystem\Exception\FileNotFoundException;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Yaml\Yaml;

/**
 * Class VersionController
 *
 * @Route("/version")
 */
class VersionController extends Controller
{

    /**
     * @Route("", name="allocine_version_version_index")
     *
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function indexAction(Request $request)
    {
        $versionFile = $this->getParameter('version_file');
        if (file_exists($versionFile)) {
            $version = Yaml::parse(file_get_contents($versionFile));
        } else {
            throw new FileNotFoundException(null, 0, null, $versionFile);
        }
        $version = array_merge(['environment' => $this->getParameter('kernel.environment')], $version);

        return $this->json($version);
    }
}