# What is AlloCineVersionBundle ?

This bundle is designed to provide a controller to expose the version you deployed for your application

# How to install it ?

Add this to your composer.json :

```bash
composer require allocine/version-bundle
```

Now you just need to add the bundle to your kernel, load the routing file and your version file path.

# How to load the routing file

In your routing.yml (app/config), add the following

```yml
allocine_version:
    resource: "@AlloCineVersionBundle/Resources/config/routing.yml"
    prefix:   /
```

In your parameters.yml (app/config), add the following

```yml
    version_file: "%kernel.root_dir%/version.yml"
```

# Useful stuff to know
Your version file must be formatted in Yaml and must have the following data:
```yml
branch: "develop"
revision: "81e6bc6f6b46953bd664151ea4590736af4e1a66"
build: "v1.0.3.71"
date: "2016-08-12T09:49:38+02:00"
```

The date is in DATE_W3C format.
Obviously, you don't have to fill the file by yourself, it must be part of your deployment process.

# Test it yourself

Crawl the `/version` route of your application and you should see the content of your version file.

# Run unit test

Create a fake version file in the previously declared path.
Then run `phpunit vendor/allocine/version-bundle`.
You should see 1 test, 6 assertions.
