<?php

namespace WM\VersionBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\Yaml\Yaml;

/**
 * Class VersionController
 */
class VersionController extends AbstractController
{

    /**
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function index(Request $request): JsonResponse
    {
        $versionFile = $this->container->getParameter('wm_version.file');
        if (file_exists($versionFile)) {
            $version = Yaml::parse(file_get_contents($versionFile));
        } else {
            throw new NotFoundHttpException('Unknown version');
        }
        $version = array_merge(['environment' => $this->container->getParameter('kernel.environment')], $version);

        $context = [
            'json_encode_options' => JsonResponse::DEFAULT_ENCODING_OPTIONS | JSON_PRETTY_PRINT,
        ];
        return $this->json($version, Response::HTTP_OK, [], $context);
    }
}
