<?php

declare(strict_types=1);

use Rector\Config\RectorConfig;
use Rector\Set\ValueObject\LevelSetList;
use Rector\Set\ValueObject\SetList;
use Rector\ValueObject\PhpVersion;

return RectorConfig::configure()
    ->withPaths([
        __DIR__ . '/Controller',
        __DIR__ . '/DependencyInjection',
        __DIR__ . '/Tests',
    ])
    ->withPhpVersion(PhpVersion::PHP_84)
    ->withSets([
        SetList::PHP_84,
        LevelSetList::UP_TO_PHP_84,
        SetList::CODE_QUALITY,
        SetList::RECTOR_PRESET,
        SetList::TYPE_DECLARATION,
    ])
    ->withImportNames(true, true, false, true)
    ->withComposerBased(true, false, true, true)
    ;
