<?php

declare(strict_types=1);

namespace WM\VersionBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;
use Symfony\Component\HttpKernel\Kernel;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
final class Configuration implements ConfigurationInterface
{
    const string DEFAULT_VERSION_FILE = '%kernel.project_dir%/version.json';

    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder(self::getRootName());
        if(Kernel::VERSION > 4.2) {
            $rootNode = $treeBuilder->getRootNode();
        } else {
            $rootNode = $treeBuilder->root('wm_version');
        }

        $rootNode
            ->children()
                ->scalarNode('file')
                    ->info('Path to the version file')
                    ->defaultValue(self::DEFAULT_VERSION_FILE)
                ->end()
            ->end();

        return $treeBuilder;
    }

    public static function getRootName(): string
    {
        return 'wm_version';
    }
}
