<?php

declare(strict_types=1);

namespace WM\VersionBundle\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

/**
 * Class VersionController
 */
class VersionController
{
    public function __construct(private readonly string $versionFile, private readonly string $env)
    {
    }

    public function index(): JsonResponse
    {
        if (!file_exists($this->versionFile)) {
            throw new NotFoundHttpException('Unknown version');

        }
        $version = json_decode(file_get_contents($this->versionFile), true);
        $version = array_merge([
            'environment' => $this->env,
            'php' => PHP_VERSION,
        ], $version);

        return new JsonResponse($version, JsonResponse::HTTP_OK, [])
            ->setEncodingOptions(JsonResponse::DEFAULT_ENCODING_OPTIONS | JSON_PRETTY_PRINT);
    }
}
