<?php

namespace WM\Search;

class Request
{
    /**
     * @var string
     */
    private $query;

    /**
     * @var string
     */
    private $brand;

    /**
     * @var bool
     */
    private $isAutocomplete;

    /**
     * @var array
     */
    private $entities;

    /**
     * @var array
     */
    private $excludedEntities;

    /**
     * @var array
     */
    private $excludedGenres;

    /**
     * @var bool
     */
    private $isBrowsableOnly;

    /**
     * @var array
     */
    private $sort;

    /**
     * @var int
     */
    private $from;

    /**
     * @var int
     */
    private $size;

    public function __construct()
    {
        $this->excludedEntities = [];
        $this->excludedGenres = [];
        $this->from = 0;
        $this->size = 10;
        $this->sort = [];
        $this->isAutocomplete = false;
        $this->isBrowsableOnly = false;
        $this->entities = [];
    }

    /**
     * @return string
     */
    public function getQuery(): string
    {
        return $this->query;
    }

    /**
     * @param string $query
     * @return Request
     */
    public function setQuery(string $query): Request
    {
        $this->query = $query;

        return $this;
    }

    /**
     * @return string
     */
    public function getBrand(): string
    {
        return $this->brand;
    }

    /**
     * @param string $brand
     *
     * @return Request
     */
    public function setBrand(string $brand): Request
    {
        $this->brand = $brand;

        return $this;
    }

    /**
     * @return bool
     */
    public function isAutocomplete(): bool
    {
        return $this->isAutocomplete;
    }

    /**
     * @param bool $isAutocomplete
     *
     * @return Request
     */
    public function setIsAutocomplete(bool $isAutocomplete): Request
    {
        $this->isAutocomplete = $isAutocomplete;

        return $this;
    }

    /**
     * @return array
     */
    public function getEntities(): array
    {
        return $this->entities;
    }

    /**
     * @return bool
     */
    public function hasEntities(): bool
    {
        return !empty($this->entities);
    }

    /**
     * @param array $entities
     *
     * @return Request
     */
    public function setEntities(array $entities): Request
    {
        $this->entities = $entities;

        return $this;
    }

    /**
     * @return array
     */
    public function getExcludedEntities(): array
    {
        return $this->excludedEntities;
    }

    /**
     * @param array $excludedEntities
     *
     * @return Request
     */
    public function setExcludedEntities(array $excludedEntities): Request
    {
        $this->excludedEntities = $excludedEntities;

        return $this;
    }

    /**
     * @return bool
     */
    public function hasExcludedEntities(): bool
    {
        return !empty($this->excludedEntities);
    }

    /**
     * @return array
     */
    public function getExcludedGenres(): array
    {
        return $this->excludedGenres;
    }

    /**
     * @param array $excludedGenres
     *
     * @return Request
     */
    public function setExcludedGenres(array $excludedGenres): Request
    {
        $this->excludedGenres = $excludedGenres;

        return $this;
    }

    /**
     * @return bool
     */
    public function hasExcludedGenres()
    {
        return !empty($this->excludedGenres);
    }

    /**
     * @return array
     */
    public function getSort(): array
    {
        return $this->sort;
    }

    /**
     * @param array $sort
     *
     * @return Request
     */
    public function setSort(array $sort): Request
    {
        $this->sort = $sort;

        return $this;
    }

    /**
     * @return int
     */
    public function getFrom(): int
    {
        return $this->from;
    }

    /**
     * @param int $from
     *
     * @return Request
     */
    public function setFrom(int $from): Request
    {
        $this->from = $from;

        return $this;
    }

    /**
     * @return int
     */
    public function getSize(): int
    {
        return $this->size;
    }

    /**
     * @param int $size
     *
     * @return Request
     */
    public function setSize(int $size): Request
    {
        $this->size = $size;

        return $this;
    }

    /**
     * @return bool
     */
    public function isBrowsableOnly(): bool
    {
        return $this->isBrowsableOnly;
    }

    /**
     * @param bool $isBrowsableOnly
     *
     * @return Request
     */
    public function setIsBrowsableOnly(bool $isBrowsableOnly): Request
    {
        $this->isBrowsableOnly = $isBrowsableOnly;

        return $this;
    }
}
