<?php

namespace WM\Search\Response;

class Suggest implements \Iterator, \Countable, \JsonSerializable
{
    /**
     * @var array
     */
    private $proposals;

    /**
     * @param array $result
     */
    public function __construct(array $result)
    {
        $this->proposals = [];

        if (!empty($result['suggest']['proposals'][0]['options'])) {
            foreach ($result['suggest']['proposals'][0]['options'] as $proposal) {
                $this->proposals[] = new Proposal($proposal);
            }
        }
    }

    /**
     * @return array
     */
    public function getProposals(): array
    {
        return $this->proposals;
    }

    /**
     * @return bool
     */
    public function hasProposal()
    {
        return !empty($this->proposals);
    }

    /**
     * @return string|null
     */
    public function getFirstProposalText()
    {
        return $this->proposals[0]->getText() ?? null;
    }

    /**
     * @return mixed
     */
    public function current()
    {
        return current($this->proposals);
    }

    /**
     * @return void
     */
    public function next()
    {
        next($this->proposals);
    }

    /**
     * @return int|mixed|null|string
     */
    public function key()
    {
        return key($this->proposals);
    }

    /**
     * @return bool
     */
    public function valid()
    {
        return key($this->proposals) !== null;
    }

    /**
     * @return void
     */
    public function rewind()
    {
        reset($this->proposals);
    }

    /**
     * @return int
     */
    public function count()
    {
        return count($this->proposals);
    }

    /**
     * @return bool|string
     */
    public function jsonSerialize()
    {
        return json_encode([
            'proposals' => $this->proposals
        ]);
    }
}
