<?php

namespace WM\Search\Response;

use WM\Search\Exception\MethodNotAllowedException;

class Item implements \ArrayAccess, \JsonSerializable
{
    private readonly string $_index;

    private readonly string $_id;

    private readonly float $_score;

    private array $_source;

    public function __construct(array $hit)
    {
        $this->_index = $hit['_index'];
        $this->_id = $hit['_id'];
        $this->_score = $hit['_score'];
        $this->_source = $hit['_source'];
    }

    public function getIndex(): string
    {
        return $this->_index;
    }

    public function getId(): string
    {
        return $this->_id;
    }

    /**
     * https://www.elastic.co/guide/en/elasticsearch/guide/current/_sorting.html#_sorting_by_field_values
     */
    public function getScore(): ?float
    {
        return $this->_score;
    }

    public function getSource(): array
    {
        return $this->_source;
    }

    public function offsetExists(mixed $offset): bool
    {
        return isset($this->_source[$offset]);
    }

    public function offsetGet(mixed $offset): mixed
    {
        return $this->_source[$offset] ?? null;
    }

    /**
     *
     * @throws MethodNotAllowedException
     */
    public function offsetSet(mixed $offset, mixed $value): void
    {
        throw new MethodNotAllowedException('Cannot modify a response item field');
    }

    /**
     * @throws MethodNotAllowedException
     */
    public function offsetUnset(mixed $offset): void
    {
        throw new MethodNotAllowedException('Cannot delete a response item field');
    }

    public function jsonSerialize(): mixed
    {
        return [
            '_index' => $this->_index,
            '_id' => $this->_id,
            '_score' => $this->_score,
            '_source' => $this->_source
        ];
    }
}
