<?php

namespace WM\Search\Response;

class Response implements \Iterator, \Countable, \JsonSerializable
{
    private int $total = 0;

    private float $maxScore = 0;

    private bool $suggested = false;

    private string $suggestion;

    private int $totalTime = 0;

    /**
     * Array of results.
     */
    private array $items = [];

    public function __construct(array $result)
    {
        if (!empty($result['hits'])) {
            $this->total = $result['hits']['total']['value'] ?? $result['hits']['total'] ?? 0;
            $this->maxScore = $result['hits']['max_score'] ?? 0;

            if (!empty($result['hits']['hits'])) {
                foreach ($result['hits']['hits'] as $hit) {
                    $this->items[] = new Item($hit);
                }
            }
        }
    }

    public function getTotal(): int
    {
        return $this->total;
    }

    public function getMaxScore(): float
    {
        return $this->maxScore;
    }

    public function getItems(): array
    {
        return $this->items;
    }

    public function setItems(array $items): Response
    {
        $this->items = $items;

        return $this;
    }

    public function isSuggested(): bool
    {
        return $this->suggested;
    }

    public function setSuggested(bool $suggested): Response
    {
        $this->suggested = $suggested;

        return $this;
    }

    public function getSuggestion(): string
    {
        return $this->suggestion;
    }

    public function setSuggestion(string $suggestion): Response
    {
        $this->suggestion = $suggestion;
        return $this;
    }

    public function isTotalTime(): int
    {
        return $this->totalTime;
    }

    public function setTotalTime(int $totalTime): Response
    {
        $this->totalTime = $totalTime;

        return $this;
    }

    public function current(): mixed
    {
        return current($this->items);
    }

    public function next(): void
    {
        next($this->items);
    }

    public function key(): mixed
    {
        return key($this->items);
    }

    public function valid(): bool
    {
        return key($this->items) !== null;
    }

    public function rewind(): void
    {
        reset($this->items);
    }

    public function count(): int
    {
        return count($this->items);
    }

    public function jsonSerialize(): mixed
    {
        return [
            'total' => $this->total,
            'max_score' => $this->maxScore,
            'suggested' => $this->suggested,
            'suggestion' => $this->suggestion,
            'items' => $this->items,
            'total_time' => $this->totalTime
        ];
    }
}
