<?php

namespace WM\Search;

class Request
{
    private string $query;

    private string $brand;

    private bool $isAutocomplete = false;

    private array $entityTypes = [];

    private array $excludedEntities = [];

    private array $excludedGenres = [];

    private bool $isBrowsableOnly = false;

    private bool $allowSpellChecking = false;

    private array $sort = [];

    private int $from = 0;

    private int $size = 10;

    public function getQuery(): string
    {
        return $this->query;
    }

    public function setQuery(string $query): Request
    {
        $this->query = $query;

        return $this;
    }

    public function getBrand(): string
    {
        return $this->brand;
    }

    public function setBrand(string $brand): Request
    {
        $this->brand = $brand;

        return $this;
    }

    public function isAutocomplete(): bool
    {
        return $this->isAutocomplete;
    }

    public function setIsAutocomplete(bool $isAutocomplete): Request
    {
        $this->isAutocomplete = $isAutocomplete;

        return $this;
    }

    public function hasEntityTypes(): bool
    {
        return $this->entityTypes !== [];
    }

    public function getEntityTypes(): array
    {
        return $this->entityTypes;
    }

    public function setEntityTypes(array $entityTypes): Request
    {
        $this->entityTypes = $entityTypes;

        return $this;
    }

    public function getExcludedEntities(): array
    {
        return $this->excludedEntities;
    }

    public function setExcludedEntities(array $excludedEntities): Request
    {
        $this->excludedEntities = $excludedEntities;

        return $this;
    }

    public function hasExcludedEntities(): bool
    {
        return $this->excludedEntities !== [];
    }

    public function getExcludedGenres(): array
    {
        return $this->excludedGenres;
    }

    public function setExcludedGenres(array $excludedGenres): Request
    {
        $this->excludedGenres = $excludedGenres;

        return $this;
    }

    public function hasExcludedGenres(): bool
    {
        return $this->excludedGenres !== [];
    }

    public function getSort(): array
    {
        return $this->sort;
    }

    public function setSort(array $sort): Request
    {
        $this->sort = $sort;

        return $this;
    }

    public function getFrom(): int
    {
        return $this->from;
    }

    public function setFrom(int $from): Request
    {
        $this->from = $from;

        return $this;
    }

    public function getSize(): int
    {
        return $this->size;
    }

    public function setSize(int $size): Request
    {
        $this->size = $size;

        return $this;
    }

    public function isBrowsableOnly(): bool
    {
        return $this->isBrowsableOnly;
    }

    public function setIsBrowsableOnly(bool $isBrowsableOnly): Request
    {
        $this->isBrowsableOnly = $isBrowsableOnly;

        return $this;
    }

    public function allowSpellChecking(): bool
    {
        return $this->allowSpellChecking;
    }

    public function setAllowSpellChecking(bool $allowSpellChecking): Request
    {
        $this->allowSpellChecking = $allowSpellChecking;

        return $this;
    }
}
