<?php

namespace WM\Search\Response;

class Proposal
{
    /**
     * Proposed phrase
     *
     * @var string
     */
    private $text;

    /**
     * @var float
     */
    private $score;

    /**
     * Has this proposal real results in the search index ?
     *
     * @var bool
     */
    private $collateMatch;

    /**
     * @param array $proposal
     */
    public function __construct(array $proposal)
    {
        $this->text = $proposal['text'];
        $this->score = $proposal['score'];
        $this->collateMatch = (isset($proposal['collate_match']) ? $proposal['collate_match'] : true);
    }

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @return float
     */
    public function getScore(): float
    {
        return $this->score;
    }

    /**
     * @return bool
     */
    public function isCollateMatch(): bool
    {
        return $this->collateMatch;
    }
}
