<?php

namespace WM\Search\Response;

class Response implements \Iterator, \Countable, \JsonSerializable
{
    /**
     * @var int
     */
    private $total;

    /**
     * @var float
     */
    private $maxScore;

    /**
     * @var bool
     */
    private $suggested;

    /**
     * @var string
     */
    private $suggestion;

    /**
     * @var int
     */
    private $totalTime;

    /**
     * Array of results.
     *
     * @var array
     */
    private $items;

    /**
     * @param array $result
     */
    public function __construct(array $result)
    {
        $this->items = [];
        $this->total = 0;
        $this->maxScore = 0;
        $this->suggested = false;
        $this->suggestion = null;
        $this->totalTime = 0;

        if (!empty($result['hits'])) {
            $this->total = $result['hits']['total']['value'] ?? $result['hits']['total'] ?? 0;
            $this->maxScore = $result['hits']['max_score'];

            if (!empty($result['hits']['hits'])) {
                foreach ($result['hits']['hits'] as $hit) {
                    $this->items[] = new Item($hit);
                }
            }
        }
    }

    /**
     * @return int
     */
    public function getTotal(): int
    {
        return $this->total;
    }

    /**
     * @return float
     */
    public function getMaxScore(): float
    {
        return $this->maxScore;
    }

    /**
     * @return array
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @param array $items
     *
     * @return Response
     */
    public function setItems(array $items): Response
    {
        $this->items = $items;

        return $this;
    }

    /**
     * @return bool
     */
    public function isSuggested(): bool
    {
        return $this->suggested;
    }

    /**
     * @param bool $suggested
     *
     * @return Response
     */
    public function setSuggested(bool $suggested): Response
    {
        $this->suggested = $suggested;

        return $this;
    }

    /**
     * @return string
     */
    public function getSuggestion(): string
    {
        return $this->suggestion;
    }

    /**
     * @param string $suggestion
     * @return Response
     */
    public function setSuggestion(string $suggestion): Response
    {
        $this->suggestion = $suggestion;
        return $this;
    }

    /**
     * @return int
     */
    public function isTotalTime(): int
    {
        return $this->totalTime;
    }

    /**
     * @param int $totalTime
     *
     * @return Response
     */
    public function setTotalTime(int $totalTime): Response
    {
        $this->totalTime = $totalTime;

        return $this;
    }

    /**
     * @return mixed
     */
    public function current()
    {
        return current($this->items);
    }

    /**
     * @return void
     */
    public function next()
    {
        next($this->items);
    }

    /**
     * @return int|mixed|null|string
     */
    public function key()
    {
        return key($this->items);
    }

    /**
     * @return bool
     */
    public function valid()
    {
        return key($this->items) !== null;
    }

    /**
     * @return void
     */
    public function rewind()
    {
        reset($this->items);
    }

    /**
     * @return int
     */
    public function count()
    {
        return count($this->items);
    }

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'total' => $this->total,
            'max_score' => $this->maxScore,
            'hits' => $this->items
        ];
    }
}
