# search-client
Elastic search client in PHP

## Installation
```bash
composer require wm/search-client
```

## usage
```php
use WM\Search\Client;

// staging
$search = new Client(['10.82.0.168:9200']);

// global search (legacy search + phrase suggestion + terms suggestion)
$results = $search->search('bac to the fufur', 'AC', ['movie'], 10);
$results = $search->search('captain soubasa', 'AC', [], 10);

// legacy search (from cluster ES 1.3)
// search for 
// - exact phrase : weight 4 (game of thrones)
// - exacts terms : weight 3 (game thrones)
// - edge-nGram (for autocomplete) : weight : 2 (gam thron)
$results = $search->legacySearch('Harry Potter', 'AC', ['movie'], 20);

// phrase suggestion
// if empty, the searched text should be correct
// can correct 3 errors max
// last arg "prune" :
//  - true => include all results and add collateMatch(true/false) to indicate 
//    if this suggestion has real results in the ES index
//  - false => include only suggestions with results in the ES index
$results = $search->phraseSuggestion('my litle ponay', 'AC', 10, true);

// one term suggestion
// if empty, the searched text should be correct
// can correct 2 errors max
$results = $search->termSuggestion('sunshayne', 'AC', 10);

// permissive search, for illiterates
// set text to search and minimum terms count that must be in results
$results = $search->permissiveSearch('Harry poter end the alf blood', 3, 'AC');
```
