<?php

declare(strict_types=1);

namespace WM\Search\Response;

class Suggest implements \Iterator, \Countable, \JsonSerializable
{
    private array $proposals = [];

    public function __construct(array $result)
    {
        if (empty($result['suggest'])) {
            return;
        }

        foreach ($result['suggest'] as $k => $v) {
            if (empty($v[0]['options'])) {
                continue;
            }

            $i = 0;
            foreach ($v[0]['options'] as $proposal) {
                $this->proposals["$k-$i"] = new Proposal($proposal);
                ++$i;
            }
        }
    }

    public function getProposals(): array
    {
        return $this->proposals;
    }

    public function hasProposal(): bool
    {
        return $this->proposals !== [];
    }

    public function getFirstProposalText(): ?string
    {
        if ($this->proposals === []) {
            return null;
        }
        $this->rewind();
        $first = $this->current();

        return ($first instanceof Proposal) ? $first->getText() : null;
    }

    public function current(): mixed
    {
        return current($this->proposals);
    }

    public function next(): void
    {
        next($this->proposals);
    }

    public function key(): int|string|null
    {
        return key($this->proposals);
    }

    public function valid(): bool
    {
        return key($this->proposals) !== null;
    }

    public function rewind(): void
    {
        reset($this->proposals);
    }

    public function count(): int
    {
        return count($this->proposals);
    }

    public function jsonSerialize(): mixed
    {
        return [
            'proposals' => $this->proposals
        ];
    }

    /**
     * Add term which does not have suggestion
     */
    public function addTermWithNoSuggestion(array $terms, array &$result): void
    {
        foreach ($terms as $key => $term) {
            $found = array_any(array_keys($result), fn($proposalKey) => str_starts_with((string) $proposalKey, "proposals-$key-"));
            if (!$found) {
                $result[$key] = $term;
            }
        }
    }
}
