<?php

declare(strict_types=1);

namespace WM\Search\Response;

class Proposal
{
    /**
     * Proposed phrase
     */
    private readonly string $text;

    private readonly float $score;

    /**
     * Has this proposal real results in the search index ?
     */
    private readonly bool $collateMatch;

    public function __construct(array $proposal)
    {
        $this->text = $proposal['text'];
        $this->score = $proposal['score'];
        $this->collateMatch = $proposal['collate_match'] ?? true;
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function getScore(): float
    {
        return $this->score;
    }

    public function isCollateMatch(): bool
    {
        return $this->collateMatch;
    }
}
