<?php

namespace WM\Search\Response;

class Suggest implements \Iterator, \Countable, \JsonSerializable
{
    /**
     * @var array
     */
    private $proposals = [];

    /**
     * @param array $result
     */
    public function __construct(array $result)
    {
        if (empty($result['suggest'])) {
            return;
        }

        foreach ($result['suggest'] as $k => $v) {
            if (empty($v[0]['options'])) {
                continue;
            }

            $i = 0;
            foreach ($v[0]['options'] as $proposal) {
                $this->proposals["$k-$i"] = new Proposal($proposal);
                ++$i;
            }
        }
    }

    /**
     * @return array
     */
    public function getProposals(): array
    {
        return $this->proposals;
    }

    /**
     * @return bool
     */
    public function hasProposal()
    {
        return !empty($this->proposals);
    }

    /**
     * @return string|null
     */
    public function getFirstProposalText(): ?string
    {
        if (empty($this->proposals)) {
            return null;
        }
        $this->rewind();
        $first = $this->current();
        return $first ? $first->getText() : null;
    }

    /**
     * @return mixed
     */
    public function current()
    {
        return current($this->proposals);
    }

    /**
     * @return void
     */
    public function next()
    {
        next($this->proposals);
    }

    /**
     * @return int|mixed|null|string
     */
    public function key()
    {
        return key($this->proposals);
    }

    /**
     * @return bool
     */
    public function valid()
    {
        return key($this->proposals) !== null;
    }

    /**
     * @return void
     */
    public function rewind()
    {
        reset($this->proposals);
    }

    /**
     * @return int
     */
    public function count()
    {
        return count($this->proposals);
    }

    /**
     * @return bool|string
     */
    public function jsonSerialize()
    {
        return json_encode([
            'proposals' => $this->proposals
        ]);
    }

    /**
     * Add term which does not have suggestion
     */
    public function addTermWithNoSuggestion(array $terms, array &$result): void
    {
        foreach ($terms as $key => $term) {
            $found = false;
            foreach ($result as $proposalKey => $proposal) {
                if (0 === strpos($proposalKey, "proposals-$key-")) {
                    $found = true;
                    break;
                }
            }
            if (!$found) {
                $result[$key] = $term;
            }
        }
    }
}
