<?php
/**
 * phplib
 * Created by Minh-Quan TRAN on 24/01/2019
 */

namespace Tests\Monolog\Processor;


use Monolog\TestCase;
use WM\Library\Monolog\Processor\WebProcessor;

class WebProcessorTest extends TestCase
{
    public function testHttpXUniqueId()
    {
        $server = array(
            'REQUEST_URI'           => 'A',
            'REMOTE_ADDR'           => 'B',
            'REQUEST_METHOD'        => 'C',
            'HTTP_REFERER'          => 'D',
            'SERVER_NAME'           => 'F',
            'UNIQUE_ID'             => 'G',
            'HTTP_X_UNIQUE_ID'      => 'H',
        );

        $processor = new WebProcessor($server);
        $record = $processor($this->getRecord());
        $this->assertEquals($server['REQUEST_URI'], $record['extra']['url']);
        $this->assertEquals($server['REMOTE_ADDR'], $record['extra']['ip']);
        $this->assertEquals($server['REQUEST_METHOD'], $record['extra']['http_method']);
        $this->assertEquals($server['HTTP_REFERER'], $record['extra']['referrer']);
        $this->assertEquals($server['SERVER_NAME'], $record['extra']['server']);
        $this->assertEquals($server['HTTP_X_UNIQUE_ID'], $record['extra']['unique_id']);
    }

    public function testTrueClientIP()
    {
        $server = array(
            'REQUEST_URI'           => 'A',
            'REMOTE_ADDR'           => 'B',
            'REQUEST_METHOD'        => 'C',
            'HTTP_REFERER'          => 'D',
            'SERVER_NAME'           => 'F',
            'UNIQUE_ID'             => 'G',
            'TRUE-CLIENT-IP'        => 'I',
        );

        $processor = new WebProcessor($server);
        $record = $processor($this->getRecord());
        $this->assertEquals($server['REQUEST_URI'], $record['extra']['url']);
        $this->assertEquals($server['TRUE-CLIENT-IP'], $record['extra']['ip']);
        $this->assertEquals($server['REQUEST_METHOD'], $record['extra']['http_method']);
        $this->assertEquals($server['HTTP_REFERER'], $record['extra']['referrer']);
        $this->assertEquals($server['SERVER_NAME'], $record['extra']['server']);
    }

    public function testHttpXFF()
    {
        $server = array(
            'REQUEST_URI'           => 'A',
            'REMOTE_ADDR'           => 'B',
            'REQUEST_METHOD'        => 'C',
            'HTTP_REFERER'          => 'D',
            'SERVER_NAME'           => 'F',
            'TRUE-CLIENT-IP'        => 'G',
            'HTTP_X_FORWARDED_FOR'  => 'H,I,J,K',
        );

        $expectedHTTP_X_FORWARDED_FOR = explode(',', $server['HTTP_X_FORWARDED_FOR'])[0];

        $processor = new WebProcessor($server);
        $record = $processor($this->getRecord());
        $this->assertEquals($server['REQUEST_URI'], $record['extra']['url']);
        $this->assertEquals($expectedHTTP_X_FORWARDED_FOR, $record['extra']['ip']);
        $this->assertEquals($server['REQUEST_METHOD'], $record['extra']['http_method']);
        $this->assertEquals($server['HTTP_REFERER'], $record['extra']['referrer']);
        $this->assertEquals($server['SERVER_NAME'], $record['extra']['server']);
        $this->assertEquals($server['HTTP_X_UNIQUE_ID'], $record['extra']['unique_id']);
    }
}
