<?php

/*
 * This file is part of the Monolog package.
 *
 * (c) Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WM\Library\Monolog\Processor;

/**
 * Adds a unique identifier issued from header X-Unique-Id set by HAProxy into records
 */
class WebProcessor extends \Monolog\Processor\WebProcessor
{
    public function __construct($serverData = null, array $extraFields = null)
    {
        parent::__construct($serverData, $extraFields);

        if (isset($this->serverData['HTTP_X_FORWARDED_FOR'])) {
            // If there is X_FORWARDED_FOR header, set Client IP as the first IP in the list
            $xff = explode(',', $this->serverData['HTTP_X_FORWARDED_FOR']);
            $this->serverData['REMOTE_ADDR'] = $xff[0] ?? $this->serverData['REMOTE_ADDR'];
        } else if (isset($this->serverData['TRUE-CLIENT-IP'])) {
            // Akamai Header
            $this->serverData['REMOTE_ADDR'] = $this->serverData['TRUE-CLIENT-IP'];
        }

        if (isset($this->serverData['HTTP_X_UNIQUE_ID'])) {
            $this->serverData['UNIQUE_ID'] = $this->serverData['HTTP_X_UNIQUE_ID'];
        }
    }
}
