<?php

namespace WM\Library\Monolog\Processor;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

class GlobalUidProcessor implements EventSubscriberInterface
{
    const GLOBAL_TRANSACTION_UID_HEADER = 'X-Unique-ID';

    /**
     * @var string
     */
    private $uid;

    /**
     * @var string
     */
    private $globalUid;

    public function __construct()
    {
        $length = 7;
        $this->uid = substr(bin2hex(random_bytes((int) ceil($length / 2))), 0, $length);
    }

    public function __invoke(array $record): array
    {
        $record['extra']['uid'] = $this->getUid();

        return $record;
    }

    public function getUid(): string
    {
        return $this->globalUid ?? $this->uid;
    }

    public function onKernelRequest(GetResponseEvent $event): void
    {
        $request = $event->getRequest();
        if ($request->headers->has(self::GLOBAL_TRANSACTION_UID_HEADER)) {
            $this->globalUid = $request->headers->get(self::GLOBAL_TRANSACTION_UID_HEADER);
        }
    }

    public static function getSubscribedEvents()
    {
        return [
            KernelEvents::REQUEST => ['onKernelRequest', 4096],
        ];
    }
}
