<?php
/**
 * phplib
 * Created by Minh-Quan TRAN on 28/01/2019
 */

namespace WM\Library\Controller;

use Liip\MonitorBundle\Helper\ArrayReporter;
use Liip\MonitorBundle\Helper\RunnerManager;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Serializer\Encoder;
use Symfony\Component\Serializer\Normalizer;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\SerializerInterface;

class HealthCheckController
{
    /**
     * @var SerializerInterface
     */
    private $serializer;
    public function __construct()
    {
        $this->serializer = new Serializer(
            [new Normalizer\ObjectNormalizer()],
            [new Encoder\JsonEncoder(new Encoder\JsonEncode(JSON_PRETTY_PRINT)), new Encoder\XmlEncoder()]
        );
    }
    /**
     * @param string        $_format
     * @param RunnerManager $runnerManager
     *
     * @return Response
     */
    public function checkAction(string $_format, RunnerManager $runnerManager)
    {
        $runner = $runnerManager->getRunner(null);
        $reporter = new ArrayReporter();
        $runner->addReporter($reporter);
        $runner->run();
        $report = [];
        $httpCode = Response::HTTP_OK;
        foreach ($reporter->getResults() as $result) {
            $result['checkname'] = str_replace('"', '__', $result['checkName']);
            if (0 != $result['status']) {
                $result['status'] = 2;
                $httpCode = Response::HTTP_INTERNAL_SERVER_ERROR;
            }
            unset($result['checkName'], $result['service_id'], $result['status_name']);
            $report[] = $result;
        }
        $response = new Response($this->serializer->serialize($report, $_format), $httpCode);
        return $response;
    }
}
