<?php

namespace Tests\Component\Console;

use AlloCine\CronReporterBundle\Component\Console\CronReporterOutput;
use PHPUnit\Framework\TestCase;

class CronReporterOutputTest extends TestCase
{

    /**
     * Test buffer
     *
     * @group functional
     */
    public function testBuffer()
    {
        $output = new CronReporterOutput();
        $output->writeln('hello AlloCiné');
        $this->assertEquals(PHP_EOL . 'hello AlloCiné', $output->getBuffer());
        $output->clearBuffer();
        $this->assertEmpty($output->getBuffer());
        $output->write('goodbye AlloCiné', false);
        $this->assertEquals('goodbye AlloCiné', $output->getBuffer());
    }
}
