<?php

namespace AlloCine\CronReporterBundle\Transports\Drivers;

use AlloCine\CronReporterBundle\Exception\TransportException;
use AlloCine\CronReporterBundle\Model\CronReporter;
use Symfony\Component\Filesystem\Filesystem as SymfonyFilesystem;

class Filesystem extends AbstractTransport
{

    /**
     * @inheritdoc
     */
    public static function getName(): string
    {
        return 'filesystem';
    }

    /**
     * @inheritdoc
     */
    public function send(CronReporter $cronReporter, callable $onSuccess = null, callable $onFailure = null): bool
    {
        $target = $this->configuration['target'];
        $name = sprintf('%s.%s.%s.txt', $cronReporter->getProject(), $cronReporter->getEnvironment(),
            $cronReporter->getJobName());
        $fullPath = $target . DIRECTORY_SEPARATOR . $name;
        try {
            $filesystem = new SymfonyFilesystem();
            $filesystem->mkdir($target);
            $filesystem->touch($fullPath);
            if (file_put_contents($fullPath, serialize($cronReporter)) === false) {
                throw TransportException::failureException('Unable to write file');
            }
            if (!is_null($onSuccess)) {
                call_user_func($onSuccess, $cronReporter);
            }

            return true;
        } catch (\Exception $exception) {
            if (!is_null($onFailure)) {
                call_user_func($onFailure, $cronReporter);
            }

            return false;
        }
    }
}
