# What is AlloCineCronReporterBundle ?

This bundle is designed to be the client side of the interactions with CronReporter API (available in deploy project)

# How to install it ?

Add this to your composer.json :

```bash
composer require allocine/cron-reporter-bundle
```

Now you just need to add the bundle to your kernel and use CronReporterTrait within your commands or cron jobs.

Here's the full configuration reference:

```yml
    allocine_cron_reporter:
        enabled: true
        project:
            name:
            brand:
        api:
            host:
            path:
            version:
            secret:
            timeout:
        fallback:
            transport:
            target:
```

# Fallback
- Filesystem
    1. Configuration must be like the following:
    ```yaml
        fallback:
            transport: filesystem
            target: "%kernel.logs_dir%/cron-reporter"    
    ```
- Slack
    1. Just declare the parameter `slack_token` in your application with the token and the transport will work like a charm.
    2. Configuration must be like the following:
    ```yaml
        fallback:
            transport: slack
            target: "#cron-reporter"    
    ```
- Mailer
    1. Ensure Swift Mailer Bundle is correctly configured
    2. Configuration must be like the following:
    ```yaml
        fallback:
            transport: mailer
            target: "refonte-exploitation@allocine.fr"    
    ```
