// +build test

package cmd

import (
	"errors"
	"fmt"
	"testing"

	"github.com/spf13/cobra"
	"gotest.tools/assert"
)

func TestPreRun(t *testing.T) {
	var cases = []struct {
		in  []string
		err error
	}{
		{[]string{}, errors.New("command to run must be specified")},
		{[]string{"test_command.sh"}, nil},
	}

	cmd := &cobra.Command{}
	for _, c := range cases {
		t.Run(fmt.Sprintf("%+v", c.in), func(t *testing.T) {
			err := preRun(cmd, c.in)
			assert.Assert(
				t,
				err == c.err || (err != nil && err.Error() == c.err.Error()),
				"\nexpected:\n%+v\nactual:\n%+v",
				err,
				c.err,
			)
		})
	}
}
