// +build test

package api

import (
	"encoding/json"
	"testing"

	"gotest.tools/assert"
)

func TestModelDefault(t *testing.T) {
	payload := CronReporterPayload{}
	encoded, _ := json.Marshal(payload)
	expected := `{"wm_cron_reporter":{"environment":"","project":"","jobName":"","description":"","brand":"","status":"","duration":0,"extraPayload":{"message":"","output":"","error_output":"","standard_output":"","memory_usage":0,"tokens":{"environments":null,"arguments":null,"options":null}}}}`
	assert.Assert(t, string(encoded) == expected)
}
