<?php

namespace WM\CronReporterBundle\Transports\Drivers;

use Psr\Log\LoggerInterface;
use WM\CronReporterBundle\Model\CronReporter;

class Monolog extends AbstractTransport
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * Slack constructor.
     *
     * @param LoggerInterface|null $logger
     */
    public function __construct(LoggerInterface $logger = null)
    {
        $this->logger = $logger;
    }

    /**
     * @inheritdoc
     */
    public static function getName(): string
    {
        return 'monolog';
    }

    /**
     * @inheritdoc
     */
    public function send(CronReporter $cronReporter, callable $onSuccess = null, callable $onFailure = null): bool
    {
        if (null === $this->logger) {
            return false;
        }

        $cronReporterPayload = $cronReporter->getExtraPayload();

        $extraData = [];
        foreach ($cronReporterPayload['data'] ?? [] as $type => $messages) {
            $extraData[$type] = implode("\n", $messages);
        }

        if (\in_array($cronReporter->getStatus(), [CronReporter::STATUS_STARTED, CronReporter::STATUS_SUCCESS], true)) {
            $message = sprintf(
                "Cron Monitor Fallback: %s %s\nCommand: %s\nStatus: %s",
                $cronReporter->getProject(),
                $cronReporter->getEnvironment(),
                $cronReporter->getJobName(),
                $cronReporter->getStatus()
            );
            $level = 'info';
        }
        else {
            $message = sprintf(
                "Cron Monitor Fallback: %s %s\nCommand: %s\nStatus: %s\nOutput:\n%s \nFallback Reason:\n`%s`\n\n\n",
                $cronReporter->getProject(), $cronReporter->getEnvironment(),
                $cronReporter->getJobName(),
                $cronReporter->getStatus(),
                $cronReporterPayload['output'] ?? '',
                $cronReporterPayload['message'] ?? ''
            );
            $level = 'error';
        }

        try {
            $this->logger->{$level}($message, $extraData);
            if ($onSuccess !== null) {
                call_user_func($onSuccess, $cronReporter);
            }
            return true;
        } catch (\Exception $exception) {
            if ($onFailure !== null) {
                call_user_func($onFailure, $cronReporter);
            }
            return false;
        }
    }
}
