<?php

namespace AlloCine\CronReporterBundle\Component\Console;

use Symfony\Component\Console\Output\ConsoleOutput;

class CronReporterOutput extends ConsoleOutput
{

    /**
     * @var string
     */
    private $buffer = '';

    /**
     * @inheritdoc
     */
    protected function doWrite($message, $newline)
    {
        parent::doWrite($message, $newline);

        $this->buffer .= $newline ? PHP_EOL . $message : $message;
    }

    /**
     * @return string
     */
    public function getBuffer(): string
    {
        return $this->buffer;
    }

    /**
     * @return self
     */
    public function clearBuffer(): CronReporterOutput
    {
        $this->buffer = '';

        return $this;
    }
}
