<?php

namespace WM\CronReporterBundle\DependencyInjection;

use WM\CronReporterBundle\Transports\Drivers\Monolog;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{

    /**
     * @inheritdoc
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder(self::getRootName());
        $rootNode = $treeBuilder->getRootNode();
        $rootNode->children()
            ->scalarNode('enabled')
                ->info('default true, allow to disable it depending on the environment')
                ->defaultTrue()
            ->end()
            ->arrayNode('project')
                ->children()
                    ->scalarNode('name')
                        ->info('the project name')
                        ->isRequired()
                        ->cannotBeEmpty()
                    ->end()
                    ->scalarNode('brand')
                        ->info('the brand name, default null')
                        ->defaultNull()
                    ->end()
                ->end()
            ->end()
            ->arrayNode('api')
                ->children()
                    ->scalarNode('host')
                        ->info('the API host with the scheme, default value https://jenkins.allocine.net')
                        ->example('https://jenkins.allocine.net')
                        ->isRequired()
                        ->cannotBeEmpty()
                        ->defaultValue('https://jenkins.allocine.net')
                    ->end()
                    ->scalarNode('path')
                        ->info('the path to reach the API, default api')
                        ->example('api')
                        ->cannotBeEmpty()
                        ->defaultValue('api')
                    ->end()
                    ->scalarNode('version')
                        ->info('the API version, default v1')
                        ->example('v1')
                        ->cannotBeEmpty()
                        ->defaultValue('v1')
                    ->end()
                    ->scalarNode('secret')
                        ->info('if your calls are signed, you can declared the key here, default null')
                        ->defaultNull()
                    ->end()
                    ->scalarNode('timeout')
                        ->info('the timeout for the API calls, default 2.0')
                        ->example('2.0')
                        ->defaultValue(2.0)
                    ->end()
                ->end()
            ->end()
            ->arrayNode('fallback')
                ->children()
                    ->enumNode('transport')
                        ->values([Monolog::getName()])
                        ->defaultValue(Monolog::getName())
                        ->info('Fallback transport in case the first attempt fails')
                    ->end()
                ->end()
            ->end()
        ->end();

        return $treeBuilder;
    }

    /**
     * @return string
     */
    public static function getRootName(): string
    {
        return 'wm_cron_reporter';
    }
}
