import { ExecException } from "child_process";

export type Arguments = { [k: string]: string };
export type Options = { [k: string]: any };
export type Environments = { [k: string]: any };

export type Status = "started" | "locked" | "success" | "failed" | "critical";

export interface AllocinePayload {
  project: string | undefined;
  jobName: string;
  uuid: string;
  description: string;
  status: Status;
  duration: number;
  environment: "dev" | "prod" | "staging";
  brand: string;
  extraPayload: {
    message: string | ExecException | undefined;
    output: string;
    standard_output: string;
    error_output: string;
    memory_usage: number;
    tokens: {
      environments: Environments;
      options: Options | undefined;
      arguments: Arguments | undefined;
    };
  };
}
