import fetch from "node-fetch";
import { AllocinePayload } from "./interfaces";

export default async (payload: AllocinePayload) => {
  const body = JSON.stringify({
    wm_cron_reporter: payload,
  });

  try {
    const r = await fetch(
      `https://deployment.allocine.net/api/v1/cron-reporter/${payload.uuid}`,
      {
        headers: { "Content-Type": "application/json" },
        method: "PUT",
        body,
      },
    );
    // const result = await r.json();
  } catch (err) {
    console.error("err", err);
  }
};
