## nodejs cron reporter

```sh
yarn dev
  -p quanproject
  -j marvin:job
  -c "node nodejs/src/test.js"
  -d "project test"
```

### cron reporter config exemple

```yml
wm_cron_reporter:
  enabled: true
  api:
    host: "https://deployment.allocine.net"
    timeout: 5.0
  project:
    name: "MoviesPro"
  fallback:
    transport: monolog
```

### api payload exemple

```sh
PUT http://dev-deployment.local.allocine.net/api/v1/cron-reporter
Accept: */*
Cache-Control: no-cache
Content-Type: application/json

{
  "wm_cron_reporter_form_type_cron_reporter": {
    "project": "<PROJECT NAME>",
    "jobName": "<COMMAND NAME>",
    "description": "<COMMAND DESCRIPTION>",
    "status": "<started|locked|success|failed|critical>",
    "duration": 0,
    "extraPayload": {
      "tokens": {
        "environments": [],
        "arguments": [],
        "options": []
      }
    },
    "environment": "dev",
    "brand": null
  }
}

###

PUT http://dev-deployment.local.allocine.net/api/v1/cron-reporter
Accept: */*
Cache-Control: no-cache
Content-Type: application/json

{
	"wm_cron_reporter_form_type_cron_reporter": {
		"project": "Deployment App",
		"jobName": "test:deploy:cron:remote-execution",
		"description": "Cron for remote executions",
		"status": "started",
		"duration": 0,
		"extraPayload": {
			"tokens": {
				"environments": {
					"TARGET_ENV": "prod",
					"HOSTNAME": "deploy",
					"APP_ROOT": "/app",
					"TERM": "xterm",
					"PHP_INI_DIR": "/usr/local/etc/php",
					"PHP_ASC_URL": "https://secure.php.net/get/php-7.1.18.tar.xz.asc/from/this/mirror",
					"PHP_CFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
					"PHP_MD5": "",
					"PHPIZE_DEPS": "autoconf \t\tdpkg-dev \t\tfile \t\tg++ \t\tgcc \t\tlibc-dev \t\tmake \t\tpkg-config \t\tre2c",
					"PHP_URL": "https://secure.php.net/get/php-7.1.18.tar.xz/from/this/mirror",
					"APACHE_ENVVARS": "/etc/apache2/envvars",
					"PHP_LDFLAGS": "-Wl,-O1 -Wl,--hash-style=both -pie",
					"PATH": "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin",
					"PHP_CPPFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
					"GPG_KEYS": "A917B1ECDA84AEC2B568FED6F50ABC807BD5DCD0 528995BFEDFBA7191D46839EF9BA0ADA31CBD89E 1729F83938DA44E27BA0F4D3DBDB397470D12172",
					"PWD": "/app",
					"USER_ID": "1000",
					"DOCUMENTROOT": "/public",
					"HOME": "/home/www-data",
					"SHLVL": "2",
					"PHP_SHA256": "8bd91cea072ea5b368cc9b4533a1a683eb426abdacbf024bb6ffa9b799cd3b01",
					"IS_DOCKER": "1",
					"APACHE_CONFDIR": "/etc/apache2",
					"PHP_EXTRA_BUILD_DEPS": "apache2-dev",
					"VIRTUAL_HOST": "dev-deployment.local.allocine.net,deploy.allocine.127.0.0.1.nip.io,user.deploy.allocine.127.0.0.1.nip.io",
					"PHP_VERSION": "7.1.18",
					"PHP_EXTRA_CONFIGURE_ARGS": "--with-apxs2 --disable-cgi",
					"_": "bin/console",
					"PHP_SELF": "bin/console",
					"SCRIPT_NAME": "bin/console",
					"SCRIPT_FILENAME": "bin/console",
					"PATH_TRANSLATED": "bin/console",
					"DOCUMENT_ROOT": "",
					"REQUEST_TIME_FLOAT": 1535738647.60392,
					"REQUEST_TIME": 1535738647,
					"argv": [
						"bin/console",
						"deploy:cron:remote-execution"
					],
					"argc": 2,
					"SHELL_VERBOSITY": 0
				},
				"arguments": [],
				"options": []
			}
		},
		"environment": "dev",
		"brand": null
	}
}

###

PUT http://dev-deployment.local.allocine.net/api/v1/cron-reporter/5c37cb5c2247d300111a20cd
Accept: */*
Cache-Control: no-cache
Content-Type: application/json

{
  "id": "5c37cb5c2247d300111a20cd",
  "project": "Deployment App",
  "jobName": "test:deploy:cron:remote-execution",
  "description": "Cron for remote executions",
  "createdAt": "2019-01-10T23:46:52+01:00",
  "status": "started",
  "duration": 0,
  "extraPayload": {
    "tokens": {
      "environments": {
        "TARGET_ENV": "prod",
        "HOSTNAME": "deploy",
        "APP_ROOT": "\/app",
        "TERM": "xterm",
        "PHP_INI_DIR": "\/usr\/local\/etc\/php",
        "PHP_ASC_URL": "https:\/\/secure.php.net\/get\/php-7.1.18.tar.xz.asc\/from\/this\/mirror",
        "PHP_CFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
        "PHP_MD5": "",
        "PHPIZE_DEPS": "autoconf \t\tdpkg-dev \t\tfile \t\tg++ \t\tgcc \t\tlibc-dev \t\tmake \t\tpkg-config \t\tre2c",
        "PHP_URL": "https:\/\/secure.php.net\/get\/php-7.1.18.tar.xz\/from\/this\/mirror",
        "APACHE_ENVVARS": "\/etc\/apache2\/envvars",
        "PHP_LDFLAGS": "-Wl,-O1 -Wl,--hash-style=both -pie",
        "PATH": "\/usr\/local\/sbin:\/usr\/local\/bin:\/usr\/sbin:\/usr\/bin:\/sbin:\/bin",
        "PHP_CPPFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
        "GPG_KEYS": "A917B1ECDA84AEC2B568FED6F50ABC807BD5DCD0 528995BFEDFBA7191D46839EF9BA0ADA31CBD89E 1729F83938DA44E27BA0F4D3DBDB397470D12172",
        "PWD": "\/app",
        "USER_ID": "1000",
        "DOCUMENTROOT": "\/public",
        "HOME": "\/home\/www-data",
        "SHLVL": "2",
        "PHP_SHA256": "8bd91cea072ea5b368cc9b4533a1a683eb426abdacbf024bb6ffa9b799cd3b01",
        "IS_DOCKER": "1",
        "APACHE_CONFDIR": "\/etc\/apache2",
        "PHP_EXTRA_BUILD_DEPS": "apache2-dev",
        "VIRTUAL_HOST": "dev-deployment.local.allocine.net,deploy.allocine.127.0.0.1.nip.io,user.deploy.allocine.127.0.0.1.nip.io",
        "PHP_VERSION": "7.1.18",
        "PHP_EXTRA_CONFIGURE_ARGS": "--with-apxs2 --disable-cgi",
        "_": "bin\/console",
        "PHP_SELF": "bin\/console",
        "SCRIPT_NAME": "bin\/console",
        "SCRIPT_FILENAME": "bin\/console",
        "PATH_TRANSLATED": "bin\/console",
        "DOCUMENT_ROOT": "",
        "REQUEST_TIME_FLOAT": 1535738647.60392,
        "REQUEST_TIME": 1535738647,
        "argv": [
          "bin\/console",
          "deploy:cron:remote-execution"
        ],
        "argc": 2,
        "SHELL_VERBOSITY": 0
      },
      "arguments": [],
      "options": []
    }
  },
  "environment": "dev",
  "brand": null
}

###

PUT http://dev-deployment.local.allocine.net/api/v1/cron-reporter
Accept: */*
Cache-Control: no-cache
Content-Type: application/json

{
	"wm_cron_reporter_form_type_cron_reporter": {
		"project": "Deployment App",
		"jobName": "test:deploy:cron:remote-execution",
		"description": "Cron for remote executions",
		"status": "success",
		"duration": 0,
		"extraPayload": {
			"tokens": {
				"environments": {
					"TARGET_ENV": "prod",
					"HOSTNAME": "deploy",
					"APP_ROOT": "/app",
					"TERM": "xterm",
					"PHP_INI_DIR": "/usr/local/etc/php",
					"PHP_ASC_URL": "https://secure.php.net/get/php-7.1.18.tar.xz.asc/from/this/mirror",
					"PHP_CFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
					"PHP_MD5": "",
					"PHPIZE_DEPS": "autoconf \t\tdpkg-dev \t\tfile \t\tg++ \t\tgcc \t\tlibc-dev \t\tmake \t\tpkg-config \t\tre2c",
					"PHP_URL": "https://secure.php.net/get/php-7.1.18.tar.xz/from/this/mirror",
					"APACHE_ENVVARS": "/etc/apache2/envvars",
					"PHP_LDFLAGS": "-Wl,-O1 -Wl,--hash-style=both -pie",
					"PATH": "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin",
					"PHP_CPPFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
					"GPG_KEYS": "A917B1ECDA84AEC2B568FED6F50ABC807BD5DCD0 528995BFEDFBA7191D46839EF9BA0ADA31CBD89E 1729F83938DA44E27BA0F4D3DBDB397470D12172",
					"PWD": "/app",
					"USER_ID": "1000",
					"DOCUMENTROOT": "/public",
					"HOME": "/home/www-data",
					"SHLVL": "2",
					"PHP_SHA256": "8bd91cea072ea5b368cc9b4533a1a683eb426abdacbf024bb6ffa9b799cd3b01",
					"IS_DOCKER": "1",
					"APACHE_CONFDIR": "/etc/apache2",
					"PHP_EXTRA_BUILD_DEPS": "apache2-dev",
					"VIRTUAL_HOST": "dev-deployment.local.allocine.net,deploy.allocine.127.0.0.1.nip.io,user.deploy.allocine.127.0.0.1.nip.io",
					"PHP_VERSION": "7.1.18",
					"PHP_EXTRA_CONFIGURE_ARGS": "--with-apxs2 --disable-cgi",
					"_": "bin/console",
					"PHP_SELF": "bin/console",
					"SCRIPT_NAME": "bin/console",
					"SCRIPT_FILENAME": "bin/console",
					"PATH_TRANSLATED": "bin/console",
					"DOCUMENT_ROOT": "",
					"REQUEST_TIME_FLOAT": 1535738647.60392,
					"REQUEST_TIME": 1535738647,
					"argv": [
						"bin/console",
						"deploy:cron:remote-execution"
					],
					"argc": 2,
					"SHELL_VERBOSITY": 0
				},
				"arguments": [],
				"options": []
			}
		},
		"environment": "dev",
		"brand": null
	}
}

###

PUT https://deployment-internal.allocine.net/api/v1/cron-reporter
Accept: */*
Cache-Control: no-cache
Content-Type: application/json

{
	"wm_cron_reporter_form_type_cron_reporter": {
		"project": "Deployment App",
		"jobName": "test:deploy:cron:remote-execution",
		"description": "Cron for remote executions",
		"status": "started",
		"duration": 0,
		"extraPayload": {
			"tokens": {
				"environments": {
					"TARGET_ENV": "prod",
					"HOSTNAME": "deploy",
					"APP_ROOT": "/app",
					"TERM": "xterm",
					"PHP_INI_DIR": "/usr/local/etc/php",
					"PHP_ASC_URL": "https://secure.php.net/get/php-7.1.18.tar.xz.asc/from/this/mirror",
					"PHP_CFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
					"PHP_MD5": "",
					"PHPIZE_DEPS": "autoconf \t\tdpkg-dev \t\tfile \t\tg++ \t\tgcc \t\tlibc-dev \t\tmake \t\tpkg-config \t\tre2c",
					"PHP_URL": "https://secure.php.net/get/php-7.1.18.tar.xz/from/this/mirror",
					"APACHE_ENVVARS": "/etc/apache2/envvars",
					"PHP_LDFLAGS": "-Wl,-O1 -Wl,--hash-style=both -pie",
					"PATH": "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin",
					"PHP_CPPFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
					"GPG_KEYS": "A917B1ECDA84AEC2B568FED6F50ABC807BD5DCD0 528995BFEDFBA7191D46839EF9BA0ADA31CBD89E 1729F83938DA44E27BA0F4D3DBDB397470D12172",
					"PWD": "/app",
					"USER_ID": "1000",
					"DOCUMENTROOT": "/public",
					"HOME": "/home/www-data",
					"SHLVL": "2",
					"PHP_SHA256": "8bd91cea072ea5b368cc9b4533a1a683eb426abdacbf024bb6ffa9b799cd3b01",
					"IS_DOCKER": "1",
					"APACHE_CONFDIR": "/etc/apache2",
					"PHP_EXTRA_BUILD_DEPS": "apache2-dev",
					"VIRTUAL_HOST": "dev-deployment.local.allocine.net,deploy.allocine.127.0.0.1.nip.io,user.deploy.allocine.127.0.0.1.nip.io",
					"PHP_VERSION": "7.1.18",
					"PHP_EXTRA_CONFIGURE_ARGS": "--with-apxs2 --disable-cgi",
					"_": "bin/console",
					"PHP_SELF": "bin/console",
					"SCRIPT_NAME": "bin/console",
					"SCRIPT_FILENAME": "bin/console",
					"PATH_TRANSLATED": "bin/console",
					"DOCUMENT_ROOT": "",
					"REQUEST_TIME_FLOAT": 1535738647.60392,
					"REQUEST_TIME": 1535738647,
					"argv": [
						"bin/console",
						"deploy:cron:remote-execution"
					],
					"argc": 2,
					"SHELL_VERBOSITY": 0
				},
				"arguments": [],
				"options": []
			}
		},
		"environment": "dev",
		"brand": null
	}
}

###

PUT https://deployment-internal.allocine.net/api/v1/cron-reporter
Accept: */*
Cache-Control: no-cache
Content-Type: application/json

{
	"wm_cron_reporter_form_type_cron_reporter": {
		"project": "Deployment App",
		"jobName": "test:deploy:cron:remote-execution",
		"description": "Cron for remote executions",
		"status": "success",
		"duration": 0,
		"extraPayload": {
			"tokens": {
				"environments": {
					"TARGET_ENV": "prod",
					"HOSTNAME": "deploy",
					"APP_ROOT": "/app",
					"TERM": "xterm",
					"PHP_INI_DIR": "/usr/local/etc/php",
					"PHP_ASC_URL": "https://secure.php.net/get/php-7.1.18.tar.xz.asc/from/this/mirror",
					"PHP_CFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
					"PHP_MD5": "",
					"PHPIZE_DEPS": "autoconf \t\tdpkg-dev \t\tfile \t\tg++ \t\tgcc \t\tlibc-dev \t\tmake \t\tpkg-config \t\tre2c",
					"PHP_URL": "https://secure.php.net/get/php-7.1.18.tar.xz/from/this/mirror",
					"APACHE_ENVVARS": "/etc/apache2/envvars",
					"PHP_LDFLAGS": "-Wl,-O1 -Wl,--hash-style=both -pie",
					"PATH": "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin",
					"PHP_CPPFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
					"GPG_KEYS": "A917B1ECDA84AEC2B568FED6F50ABC807BD5DCD0 528995BFEDFBA7191D46839EF9BA0ADA31CBD89E 1729F83938DA44E27BA0F4D3DBDB397470D12172",
					"PWD": "/app",
					"USER_ID": "1000",
					"DOCUMENTROOT": "/public",
					"HOME": "/home/www-data",
					"SHLVL": "2",
					"PHP_SHA256": "8bd91cea072ea5b368cc9b4533a1a683eb426abdacbf024bb6ffa9b799cd3b01",
					"IS_DOCKER": "1",
					"APACHE_CONFDIR": "/etc/apache2",
					"PHP_EXTRA_BUILD_DEPS": "apache2-dev",
					"VIRTUAL_HOST": "dev-deployment.local.allocine.net,deploy.allocine.127.0.0.1.nip.io,user.deploy.allocine.127.0.0.1.nip.io",
					"PHP_VERSION": "7.1.18",
					"PHP_EXTRA_CONFIGURE_ARGS": "--with-apxs2 --disable-cgi",
					"_": "bin/console",
					"PHP_SELF": "bin/console",
					"SCRIPT_NAME": "bin/console",
					"SCRIPT_FILENAME": "bin/console",
					"PATH_TRANSLATED": "bin/console",
					"DOCUMENT_ROOT": "",
					"REQUEST_TIME_FLOAT": 1535738647.60392,
					"REQUEST_TIME": 1535738647,
					"argv": [
						"bin/console",
						"deploy:cron:remote-execution"
					],
					"argc": 2,
					"SHELL_VERBOSITY": 0
				},
				"arguments": [],
				"options": []
			}
		},
		"environment": "dev",
		"brand": null
	}
}

###

PUT https://deployment-internal.allocine.net/api/v1/cron-reporter/5bc6070cd50aba6e3567d02c
Accept: */*
Cache-Control: no-cache
Content-Type: application/json

{
  "id": "5bc6070cd50aba6e3567d02c",
  "project": "Deployment App",
  "jobName": "test:deploy:cron:remote-execution",
  "description": "Cron for remote executions",
  "createdAt": "2018-10-16T17:43:08+02:00",
  "status": "started",
  "duration": 0,
  "extraPayload": {
    "tokens": {
      "environments": {
        "TARGET_ENV": "prod",
        "HOSTNAME": "deploy",
        "APP_ROOT": "\/app",
        "TERM": "xterm",
        "PHP_INI_DIR": "\/usr\/local\/etc\/php",
        "PHP_ASC_URL": "https:\/\/secure.php.net\/get\/php-7.1.18.tar.xz.asc\/from\/this\/mirror",
        "PHP_CFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
        "PHP_MD5": "",
        "PHPIZE_DEPS": "autoconf \t\tdpkg-dev \t\tfile \t\tg++ \t\tgcc \t\tlibc-dev \t\tmake \t\tpkg-config \t\tre2c",
        "PHP_URL": "https:\/\/secure.php.net\/get\/php-7.1.18.tar.xz\/from\/this\/mirror",
        "APACHE_ENVVARS": "\/etc\/apache2\/envvars",
        "PHP_LDFLAGS": "-Wl,-O1 -Wl,--hash-style=both -pie",
        "PATH": "\/usr\/local\/sbin:\/usr\/local\/bin:\/usr\/sbin:\/usr\/bin:\/sbin:\/bin",
        "PHP_CPPFLAGS": "-fstack-protector-strong -fpic -fpie -O2",
        "GPG_KEYS": "A917B1ECDA84AEC2B568FED6F50ABC807BD5DCD0 528995BFEDFBA7191D46839EF9BA0ADA31CBD89E 1729F83938DA44E27BA0F4D3DBDB397470D12172",
        "PWD": "\/app",
        "USER_ID": "1000",
        "DOCUMENTROOT": "\/public",
        "HOME": "\/home\/www-data",
        "SHLVL": "2",
        "PHP_SHA256": "8bd91cea072ea5b368cc9b4533a1a683eb426abdacbf024bb6ffa9b799cd3b01",
        "IS_DOCKER": "1",
        "APACHE_CONFDIR": "\/etc\/apache2",
        "PHP_EXTRA_BUILD_DEPS": "apache2-dev",
        "VIRTUAL_HOST": "dev-deployment.local.allocine.net,deploy.allocine.127.0.0.1.nip.io,user.deploy.allocine.127.0.0.1.nip.io",
        "PHP_VERSION": "7.1.18",
        "PHP_EXTRA_CONFIGURE_ARGS": "--with-apxs2 --disable-cgi",
        "_": "bin\/console",
        "PHP_SELF": "bin\/console",
        "SCRIPT_NAME": "bin\/console",
        "SCRIPT_FILENAME": "bin\/console",
        "PATH_TRANSLATED": "bin\/console",
        "DOCUMENT_ROOT": "",
        "REQUEST_TIME_FLOAT": 1535738647.60392,
        "REQUEST_TIME": 1535738647,
        "argv": [
          "bin\/console",
          "deploy:cron:remote-execution"
        ],
        "argc": 2,
        "SHELL_VERBOSITY": 0
      },
      "arguments": [],
      "options": []
    }
  },
  "environment": "dev",
  "brand": null
}

###


```
