<?php

namespace AlloCine\CronReporterBundle\Tests\Model;

use AlloCine\CronReporterBundle\Model\CronReporter;

class CronReporterTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Test count properties
     *
     * @group functional
     */
    public function testCountProperties()
    {
        $cronReporter = new CronReporter('fake_project', 'db update', 'prod');
        $reflection = new \ReflectionClass($cronReporter);

        $this->assertCount(10, $reflection->getProperties());
    }

    /**
     * Test constants
     *
     * @group functional
     */
    public function testConstants()
    {
        $this->assertEquals('success', CronReporter::STATUS_SUCCESS);
        $this->assertEquals('failed', CronReporter::STATUS_FAILED);
        $this->assertEquals('started', CronReporter::STATUS_STARTED);
    }
}
