<?php

namespace AlloCine\CronReporterBundle\Tests\Component\Console;

use AlloCine\CronReporterBundle\Component\Console\CronReporterOutput;

class CronReporterOutputTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Test buffer
     *
     * @group functional
     */
    public function testBuffer()
    {
        $output = new CronReporterOutput();
        $output->writeln('hello AlloCiné');
        $this->assertEquals(PHP_EOL . 'hello AlloCiné', $output->getBuffer());
        $output->clearBuffer();
        $this->assertEmpty($output->getBuffer());
        $output->write('goodbye AlloCiné', false);
        $this->assertEquals('goodbye AlloCiné', $output->getBuffer());
    }
}
