<?php

namespace AlloCine\CronReporterBundle\Component\Console;

use Symfony\Component\Console\Output\StreamOutput;

class CronReporterStreamOutput extends StreamOutput
{

    /**
     * @var string
     */
    private $buffer = '';

    /**
     * @return string
     */
    public function getBuffer(): string
    {
        return $this->buffer;
    }

    /**
     * @return self
     */
    public function clearBuffer(): CronReporterStreamOutput
    {
        $this->buffer = '';

        return $this;
    }

    /**
     * @inheritdoc
     */
    protected function doWrite($message, $newline)
    {
        parent::doWrite($message, $newline);

        $this->buffer .= $newline ? PHP_EOL . $message : $message;
    }
}
