<?php

namespace AlloCine\CronReporterBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class TransportPass implements CompilerPassInterface
{

    /**
     * @inheritdoc
     */
    public function process(ContainerBuilder $container)
    {
        if (!$container->hasParameter('allo_cine_cron_reporter.fallback')) {
            return;
        }

        $config = $container->getParameter('allo_cine_cron_reporter.fallback');
        $taggedServices = $container->findTaggedServiceIds('allocine.cron_reporter.transport');
        $factory = $container->getDefinition('allocine_cron_reporter.transports.transport_factory');
        foreach ($taggedServices as $id => $tags) {
            $definition = $container->getDefinition($id)->addMethodCall('setConfiguration', [$config]);
            $container->setDefinition($id, $definition);
            $factory->addMethodCall('addTransport', [new Reference($id)]);
        }
    }
}
