# What is WMCronReporterBundle ?

This bundle is designed to be the client side of the interactions with CronReporter API (available in deploy project)

# How to install it ?

Add this to your composer.json :

```bash
composer require wm/cron-reporter-bundle
```

Now you just need to add the bundle to your kernel and use CronReporterTrait within your commands or cron jobs.

Here's the full configuration reference:

```yaml
wm_cron_reporter:
    enabled: true
    project:
        name:
        brand:
    api:
        host:
        path:
        version:
        secret:
        timeout:
    fallback:
        transport:
```

# Fallback
Monolog is used to abstract the transport layer, by using the monolog channel `monolog.logger.cron_reporter`, so you 
need to configure this channel and a handler for this channel.

For Slack:
```yaml
monolog:
    channels: ['cron_reporter']
    handlers:
        cron_reporter:
            channels: ['cron_reporter']
            type: slackwebhook
            webhook_url:
            channel: #your_channel_in_slack
```

For File:
```yaml
monolog:
    channels: ['cron_reporter']
    handlers:
        cron_reporter:
            channels: ['cron_reporter']
            type: stream
            path: "%kernel.logs_dir%/cron-reporter.log"
```

For Email:
```yaml
monolog:
    channels: ['cron_reporter']
    handlers:
        cron_reporter:
            channels: ['cron_reporter']
            type: swift_mailer or native_mailer
            from_email:
            to_email:
            subject:
```
