<?php

namespace WM\CronReporterBundle\Component\Console;

use Symfony\Component\Console\Output\ConsoleOutput;

class CronReporterOutput extends ConsoleOutput
{

    /**
     * @var string
     */
    private $buffer = '';

    /**
     * CronReporterOutput constructor.
     *
     * @inheritdoc
     */
    public function __construct($verbosity = self::VERBOSITY_NORMAL, $decorated = null, $formatter = null)
    {
        parent::__construct($verbosity, $decorated, $formatter);
        $this->setErrorOutput(new CronReporterStreamOutput($this->openErrorStream(), $verbosity, $decorated,
            $this->getFormatter()));
    }

    /**
     * @return string
     */
    public function getBuffer(): string
    {
        return $this->buffer;
    }

    /**
     * @return self
     */
    public function clearBuffer(): CronReporterOutput
    {
        $this->buffer = '';

        return $this;
    }

    /**
     * @inheritdoc
     */
    protected function doWrite($message, $newline)
    {
        parent::doWrite($message, $newline);

        $this->buffer .= $newline ? $message . PHP_EOL : $message;
    }

    /**
     * @return resource
     */
    protected function openErrorStream()
    {
        return fopen($this->hasStderrSupport() ? 'php://stderr' : 'php://output', 'w');
    }
}
