<?php

namespace AlloCine\CronReporterBundle\Transports;

use AlloCine\CronReporterBundle\Exception\TransportException;

class TransportFactory
{

    /**
     * @var array
     */
    private $transports = [];

    /**
     * @param TransportInterface $transport
     *
     * @return $this
     */
    public function addTransport(TransportInterface $transport)
    {
        $this->transports[$transport::getName()] = $transport;

        return $this;
    }

    /**
     * @param string $name
     *
     * @return TransportInterface
     * @throws TransportException
     */
    public function get(string $name): TransportInterface
    {
        if (!isset($this->transports[$name])) {
            throw TransportException::notFoundException(sprintf('Transport "%s" not found', $name));
        }

        return $this->transports[$name];
    }
}
