<?php

namespace Tests\Component\Console;

use AlloCine\CronReporterBundle\Component\Console\SharedBufferCronReporterOutput;
use PHPUnit\Framework\TestCase;

class SharedBufferCronReporterOutputTest extends TestCase
{

    /**
     * Test buffer
     *
     * @group functional
     */
    public function testBuffer()
    {
        $output = new SharedBufferCronReporterOutput();
        $output->writeln('hello AlloCiné');
        $this->assertEquals('hello AlloCiné'.PHP_EOL, $output->getBuffer());
        $output->clearBuffer();
        $this->assertEmpty($output->getBuffer());
        $output->write('goodbye AlloCiné', false);
        $this->assertEquals('goodbye AlloCiné', $output->getBuffer());
        $output->clearSharedBuffer();
    }

    /**
     * Test shared buffer
     *
     * @group functional
     */
    public function testSharedBuffer()
    {
        $output = new SharedBufferCronReporterOutput();
        $output->writeln('hello AlloCiné');
        $output->getErrorOutput()->writeln('an error occurred');
        $this->assertEquals('hello AlloCiné' . PHP_EOL . 'an error occurred' . PHP_EOL, $output->getSharedBuffer());

        $output->clearSharedBuffer();
        $this->assertEmpty($output->getSharedBuffer());

        $output->write('goodbye AlloCiné', false);
        $this->assertEquals('goodbye AlloCiné', $output->getSharedBuffer());
        $output->clearSharedBuffer();

        $output->getErrorOutput()->writeln('an exception was thrown');
        $this->assertEquals('an exception was thrown' . PHP_EOL, $output->getSharedBuffer());
        $output->clearSharedBuffer();
    }
}
