<?php

namespace AlloCine\CronReporterBundle\Component\Console;

use Symfony\Component\Console\Output\StreamOutput;

class CronReporterStreamOutput extends StreamOutput
{

    /**
     * @var string
     */
    private $buffer = '';

    /**
     * @var null|SharedBufferCronReporterOutput
     */
    private $sharedBufferCronReporterOutput;

    /**
     * CronReporterStreamOutput constructor.
     *
     * @param resource                            $stream
     * @param bool|int                            $verbosity
     * @param null                                $decorated
     * @param null                                $formatter
     * @param null|SharedBufferCronReporterOutput $sharedBufferCronReporterOutput
     */
    public function __construct(
        $stream,
        $verbosity = self::VERBOSITY_NORMAL,
        $decorated = null,
        $formatter = null,
        SharedBufferCronReporterOutput $sharedBufferCronReporterOutput = null
    ) {
        parent::__construct($stream, $verbosity, $decorated, $formatter);
        $this->sharedBufferCronReporterOutput = $sharedBufferCronReporterOutput;
    }

    /**
     * @return string
     */
    public function getBuffer(): string
    {
        return $this->buffer;
    }

    /**
     * @return self
     */
    public function clearBuffer(): CronReporterStreamOutput
    {
        $this->buffer = '';

        return $this;
    }

    /**
     * @inheritdoc
     */
    protected function doWrite($message, $newline)
    {
        parent::doWrite($message, $newline);

        $this->buffer .= $newline ? $message . PHP_EOL : $message;

        if (!is_null($this->sharedBufferCronReporterOutput)) {
            $this->sharedBufferCronReporterOutput->addMessage($message, $newline);
        }
    }
}
