package api

type CronReporterPayload struct {
	Root CronReporter `json:"wm_cron_reporter"`
}
type CronReporter struct {
	Environment  string                   `json:"environment"`
	Project      string                   `json:"project"`
	JobName      string                   `json:"jobName"`
	Description  string                   `json:"description"`
	Brand        string                   `json:"brand"`
	Status       string                   `json:"status"`
	Duration     int                      `json:"duration"`
	ExtraPayload CronReporterExtraPayload `json:"extraPayload"`
}

type CronReporterExtraPayload struct {
	Message        string             `json:"message"`
	Output         string             `json:"output"`
	ErrorOutput    string             `json:"error_output"`
	StandardOutput string             `json:"standard_output"`
	MemoryUsage    int64              `json:"memory_usage"`
	Tokens         CronReporterTokens `json:"tokens"`
}

type CronReporterTokens struct {
	Environments interface{} `json:"environments"`
	Arguments    interface{} `json:"arguments"`
	Options      interface{} `json:"options"`
}
