// +build test

package utils

import (
	"fmt"
	"testing"

	"gotest.tools/assert"
)

func TestGetCommit(t *testing.T) {
	var cases = []struct {
		in  string
		out string
	}{
		{"e6829cc868314dc52de8b626086d3b5e6055c0c1", "e6829cc8"},
		{"", "dev"},
	}

	for _, c := range cases {
		t.Run(fmt.Sprintf("Input %s", c.in), func(t *testing.T) {
			GitCommit = c.in
			result := GetCommit()
			assert.Assert(
				t,
				c.out == result,
				"\nexpected:\n%+v\nactual:\n%+v",
				c.out,
				result,
			)
		})
	}
}

func TestGetVersion(t *testing.T) {
	var cases = []struct {
		in  string
		out string
	}{
		{"version", "version"},
		{"", "dev"},
	}

	for _, c := range cases {
		t.Run(fmt.Sprintf("Input %s", c.in), func(t *testing.T) {
			Version = c.in
			result := GetVersion()
			assert.Assert(
				t,
				c.out == result,
				"\nexpected:\n%+v\nactual:\n%+v",
				c.out,
				result,
			)
		})
	}
}
