package main

import (
	"fmt"
	"os"

	"git.webedia-group.net/allocine/cron-reporter-bundle/cli/cmd"
	"git.webedia-group.net/allocine/cron-reporter-bundle/cli/utils"
)

func main() {
	printVersion()
	rootCmd := cmd.CreateRootCmd()
	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}

func printVersion() {
	fmt.Printf(
		"Cron (%s-%s) (Go %s)\n",
		utils.GetVersion(),
		utils.GetCommit(),
		utils.GetRuntimeVersion(),
	)
}
