// +build test

package api

import (
	"testing"
	"time"

	"gotest.tools/assert"
)

func TestUuid(t *testing.T) {
	layout := "2006-01-02T15:04:05.000Z"
	str := "2019-08-21T11:45:26.371Z"
	testTime, err := time.Parse(layout, str)
	if err != nil {
		panic(err)
	}

	actual := Uuid("dev", "project-test", "job-dev", &testTime)
	expected := "592c8c40-5039-5917-ae39-7d21154f1c1d"
	assert.Assert(t, actual.String() == expected)
}
