#!/usr/bin/env bash
set -eufo pipefail

function clean {
    local image=${1}
    local images_to_delete=$(gcloud container images list-tags ${image} --filter="timestamp.datetime<-1W AND NOT tags:v*"  --format="value(digest)")
    for image_digest in ${images_to_delete}; do
        echo "Removing ${image_digest}"
        gcloud container images delete -q "${image}@sha256:${image_digest}" --force-delete-tags
    done
}

clean "${IMAGE_FQDN}"
